﻿within SolarTherm.Media.CO2;
package CO2_ph "CO2, explicit in p and h, in range 60 - 300 bars, 20 - 800°C"
  /* For a new medium, make a copy of this package and remove
                      the "partial" keyword from the package definition above.
                      The statement below extends from PartialMedium and sets some
                      package constants. Provide values for these constants
                      that are appropriate for your medium model. Note that other
                      constants (such as nX, nXi) are automatically defined by
                      definitions given in the base class Interfaces.PartialMedium"
              */
  extends Modelica.Media.Interfaces.PartialMedium(ThermoStates = Modelica.Media.Interfaces.Choices.IndependentVariables.ph, final mediumName = "CO2", final substanceNames = {"CO2"}, final singleState = false, final reducedX = true, final fixedX = true, Temperature(min = 20, max = 873.15, start = 500));
  import SolarTherm.Media.CO2.CO2_utilities.*;
  // Provide medium constants here
  //constant SpecificHeatCapacity cp_const=123456
  // "Constant specific heat capacity at constant pressure";
  /* The vector substanceNames is mandatory, as the number of
                      substances is determined based on its size. Here we assume
                      a single-component medium.
                      singleState is true if u and d do not depend on pressure, but only
                      on a thermal variable (temperature or enthalpy). Otherwise, set it
                      to false.
                      For a single-substance medium, just set reducedX and fixedX to true, and there's
                      no need to bother about medium compositions at all. Otherwise, set
                      final reducedX = true if the medium model has nS-1 independent mass
                      fraction, or reducedX = false if the medium model has nS independent
                      mass fractions (nS = number of substances).
                      If a mixture has a fixed composition set fixedX=true, otherwise false.
                      The modifiers for reducedX and fixedX should normally be final
                      since the other equations are based on these values.

                      It is also possible to redeclare the min, max, and start attributes of
                      Medium types, defined in the base class Interfaces.PartialMedium
                      (the example of Temperature is shown here). Min and max attributes
                      should be set in accordance to the limits of validity of the medium
                      model, while the start attribute should be a reasonable default value
                      for the initialization of nonlinear solver iterations */
  /* Provide an implementation of model BaseProperties,
                      that is defined in PartialMedium. Select two independent
                      variables from p, T, d, u, h. The other independent
                      variables are the mass fractions "Xi", if there is more
                      than one substance. Provide 3 equations to obtain the remaining
                      variables as functions of the independent variables.
                      It is also necessary to provide two additional equations to set
                      the gas constant R and the molar mass MM of the medium.
                      Finally, the thermodynamic state vector, defined in the base class
                      Interfaces.PartialMedium.BaseProperties, should be set, according to
                      its definition (see ThermodynamicState below).
                      The computation of vector X[nX] from Xi[nXi] is already included in
                      the base class Interfaces.PartialMedium.BaseProperties, so it should not
                      be repeated here.
                      The code fragment below is for a single-substance medium with
                      p,T as independent variables.
              */
  import SI=Modelica.SIunits;
  
  type Temperature = Real (
      final quantity="ThermodynamicTemperature",
      final unit="K",
      min=273.15,
      max=1200,
      start=300,
      nominal=300,
      displayUnit="degC")
      "Temperature of the medium; add of min and max constraints"
      annotation(absoluteValue=true);
      
  constant Modelica.Blocks.Types.ExternalCombiTable2D tableIDu_p_h = Modelica.Blocks.Types.ExternalCombiTable2D(
        tableName = "U",fileName= Modelica.Utilities.Files.loadResource("modelica://SolarTherm/Data/CO2/Props_from_P_H.txt"),table=fill(0.0, 0, 2),smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments);

  constant Modelica.Blocks.Types.ExternalCombiTable2D tableIDeta_p_h = Modelica.Blocks.Types.ExternalCombiTable2D(
        tableName = "DynamicViscosity",fileName= Modelica.Utilities.Files.loadResource("modelica://SolarTherm/Data/CO2/Props_from_P_H.txt"),table=fill(0.0, 0, 2),smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments);

  constant Modelica.Blocks.Types.ExternalCombiTable2D tableIDlambda_p_h = Modelica.Blocks.Types.ExternalCombiTable2D(
        tableName = "Conductivity",fileName= Modelica.Utilities.Files.loadResource("modelica://SolarTherm/Data/CO2/Props_from_P_H.txt"),table=fill(0.0, 0, 2),smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments);

  constant Modelica.Blocks.Types.ExternalCombiTable2D tableIDhelmholtz_p_h = Modelica.Blocks.Types.ExternalCombiTable2D(
        tableName = "HelmhotzEnergy",fileName= Modelica.Utilities.Files.loadResource("modelica://SolarTherm/Data/CO2/Props_from_P_H.txt"),table=fill(0.0, 0, 2),smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments);

  constant Modelica.Blocks.Types.ExternalCombiTable2D tableIDcp_p_h = Modelica.Blocks.Types.ExternalCombiTable2D(
        tableName = "CP",fileName= Modelica.Utilities.Files.loadResource("modelica://SolarTherm/Data/CO2/Props_from_P_H.txt"),table=fill(0.0, 0, 2),smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments);

 constant Modelica.Blocks.Types.ExternalCombiTable2D tableIDs_p_h = Modelica.Blocks.Types.ExternalCombiTable2D(
        tableName = "Entropy",fileName= Modelica.Utilities.Files.loadResource("modelica://SolarTherm/Data/CO2/Props_from_P_H.txt"),table=fill(0.0, 0, 2),smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments);

constant Modelica.Blocks.Types.ExternalCombiTable2D tableIDcv_p_h = Modelica.Blocks.Types.ExternalCombiTable2D(
        tableName = "CV",fileName= Modelica.Utilities.Files.loadResource("modelica://SolarTherm/Data/CO2/Props_from_P_H.txt"),table=fill(0.0, 0, 2),smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments);

  redeclare record extends ThermodynamicState "A selection of variables that uniquely defines the thermodynamic state"
      AbsolutePressure p "Absolute pressure of medium";
      SpecificEnthalpy h "Specific enthalpy";
    annotation (
      Documentation(info = "<html>

                        </html>"));
  end ThermodynamicState;

  redeclare model extends BaseProperties(final standardOrderComponents = true) "Base properties of medium"
  protected
  outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDd_p_h;
  outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDT_p_h;
  equation
      d = rho_p_h(state.p,state.h,tableIDd_p_h);
      h = state.h;
      u = h - p / d;
      MM = 0.044;
      R = 8.3144 / MM;
      state.p = p;
      T = T_p_h(p, h, tableIDT_p_h);
  end BaseProperties;
  /* Provide implementations of the following optional properties.
                      If not available, delete the corresponding function.
                      The record "ThermodynamicState" contains the input arguments
                      of all the function and is defined together with the used
                      type definitions in PartialMedium. The record most often contains two of the
              variables "p, T, d, h" (e.g., medium.T)
              */



  redeclare function setState_pTX "Return thermodynamic state from p, T, and X or Xi"
    extends Modelica.Icons.Function;
    input AbsolutePressure p "Pressure";
    input Temperature T "Temperature";
    input MassFraction X[:] = reference_X "Mass fractions";
    output ThermodynamicState state "Thermodynamic state record";
  protected
      outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDh_p_T;
  algorithm
    state := ThermodynamicState(p = p, h = h_p_T(p=p,T=T,tableID=tableIDh_p_T));
  end setState_pTX;

  redeclare function setState_phX "Return thermodynamic state from p, h, and X or Xi"
    extends Modelica.Icons.Function;
    input AbsolutePressure p "Pressure";
    input SpecificEnthalpy h "Specific enthalpy";
    input MassFraction X[:] = reference_X "Mass fractions";
    output ThermodynamicState state "Thermodynamic state record";
  algorithm
    state := ThermodynamicState(p = p, h = h);
  end setState_phX;

  redeclare function setState_psX "Return thermodynamic state from p, s, and X or Xi"
    extends Modelica.Icons.Function;
    input AbsolutePressure p "Pressure";
    input SpecificEntropy s "Specific entropy";
    input MassFraction X[:] = reference_X "Mass fractions";
    output ThermodynamicState state "Thermodynamic state record";
  protected
      outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDh_p_s;
  algorithm
    state := ThermodynamicState(p = p, h = h_p_s(p,s,tableIDh_p_s));
  end setState_psX;

  redeclare function extends pressure "Return pressure"
  algorithm
      p := state.p;
    annotation (
      Inline = true);
  end pressure;

  redeclare function extends temperature "Return temperature"
  protected
      outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDT_p_h;
  algorithm
      T := T_p_h(state.p,state.h,tableIDT_p_h);
    annotation (
      Inline = true);
  end temperature;

  redeclare function extends specificEnthalpy "Return specific enthalpy"
  algorithm
      h := state.h;
    annotation (
      Inline = true);
  end specificEnthalpy;

  redeclare function extends density "Return density"
  protected
      outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDd_p_h;
  algorithm
      d := rho_p_h(state.p,state.h,tableIDd_p_h);
    annotation (
      Inline = true);
  end density;

  redeclare function extends specificInternalEnergy "Return specific internal energy"
  protected
      outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDu_p_h;
  algorithm
      u := u_p_h(state.p,state.h,tableIDu_p_h);
    annotation (
      Inline = true);
  end specificInternalEnergy;

  redeclare function extends dynamicViscosity "Return dynamic viscosity"
  algorithm
      eta := eta_p_h(state.p,state.h,tableIDeta_p_h)*10^(-6);
    annotation (
      Documentation(info = "<html>

                        </html>"));
  end dynamicViscosity;

  redeclare function extends thermalConductivity "Return thermal conductivity"
  algorithm
      lambda := lambda_p_h(state.p,state.h,tableIDlambda_p_h);
    annotation (
      Documentation(info = "<html>

                        </html>"));
  end thermalConductivity;


  redeclare function extends specificEntropy "Return specific entropy"
  algorithm
      s := s_p_h(state.p,state.h,tableIDs_p_h);
    annotation (
      Documentation(info = "<html>

                        </html>"));
  end specificEntropy;

  redeclare function extends specificHelmholtzEnergy "Return specific Helmholtz energy"
  algorithm
      f := helmholtz_p_h(state.p,state.h,tableIDhelmholtz_p_h);
    annotation (
      Documentation(info = "<html>

                </html>"));
  end specificHelmholtzEnergy;

  redeclare function extends specificHeatCapacityCp "Return specific heat capacity at constant pressure"
  algorithm
      cp := cp_p_h(state.p,state.h,tableIDcp_p_h);
    annotation (
      Documentation(info = "<html>

                        </html>"));
  end specificHeatCapacityCp;

  redeclare function extends specificHeatCapacityCv "Return specific heat capacity at constant volume"
  algorithm
      cv := cv_p_h(state.p,state.h,tableIDcv_p_h);
    annotation (
      Documentation(info = "<html>

                        </html>"));
  end specificHeatCapacityCv;
  
  function ToutTurb
  input SI.ThermodynamicTemperature T_high;
  input SI.AbsolutePressure p_high;
  input SI.AbsolutePressure p_low;
  input SI.Efficiency eta_turb;
  output SI.ThermodynamicTemperature T_out;
  protected
  outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDh_p_T;
  outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDT_p_h;
  outer Modelica.Blocks.Types.ExternalCombiTable2D tableIDh_p_s;
  algorithm
    T_out:=T_out_turb(T_high,p_high,p_low,eta_turb,tableIDh_p_T,tableIDs_p_h,tableIDT_p_h,tableIDh_p_s);
    end ToutTurb;
    
end CO2_ph;
